(defun c:lpina()
(setq F (getvar "blipmode")) (setvar "blipmode" 0)
(setq p (getpoint "Insert point:"))
(setq D (getint "\n Enter diameter [16] [20] [25] [30] [35] [40] [50] [60]:"))
(setq L (getint "Enter cavity plate thickness:"))
(setq L1 (getint "Enter core plate thickness:"))
(setq A (getreal "Enter lpina angle:"))
(setq B (* pi (/ A 180)))
(if (= D 16)
 (progn
  (setq D1 20)
  (setq H 6)
  (setq M 8)))
(if (= D 20)
 (progn
  (setq D1 25)
  (setq H 6)
  (setq M 10)))
(if (= D 25)
 (progn
  (setq D1 30)
  (setq H 8)
  (setq M 12)))
(if (= D 30)
 (progn
  (setq D1 35)
  (setq H 8)
  (setq M 15)))
(if (= D 35)
 (progn
  (setq D1 40)
  (setq H 8)
  (setq M 15)))
(if (= D 40)
 (progn
  (setq D1 45)
  (setq H 10)
  (setq M 20)))
(if (= D 50)
 (progn
  (setq D1 56)
  (setq H 12)
  (setq M 25)))
(if (= D 60)
 (progn
  (setq D1 66)
  (setq H 15)
  (setq M 25)))
(setq p1 (polar p (+ B pi) (- L1 H)))
(setq p2 (polar p1 B 4))
(setq p3 (polar p2 (+ B (/ pi 2)) (- (/ D 2.0) 0.5)))
(setq p4 (polar p2 (- B (/ pi 2)) (- (/ D 2.0) 0.5)))
(setq p5 (polar p2 (+ B (/ pi 2)) (/ D 2.0)))
(setq p6 (polar p2 (- B (/ pi 2)) (/ D 2.0)))
(setq p9 (polar p1 (+ B (/ pi 2)) (/ D1 2)))
(setq p10 (polar p1 (- B (/ pi 2)) (/ D1 2)))
(setq p11 (polar p9 (+ B pi) H))
(setq p12 (polar p10 (+ B pi) H))
(setq p7 (polar p (+ B (/ pi 2)) (/ D 2.0)))
(setq p8 (polar p (- B (/ pi 2)) (/ D 2.0)))
(setq p13 (polar p1 (+ B (/ pi 2)) (- (/ D 2.0) 0.5)))
(setq p14 (polar p1 (- B (/ pi 2)) (- (/ D 2.0) 0.5)))
(command "break" p7 p8)
(command "line" p11 p12 p10 p9 "c")
(command "line" p5 p6 p8 p7 "c")
(command "line" p3 p13 "")
(command "line" p4 p14 "")
(setq p15 (polar p B (- L 2)))
(setq p16 (polar p B (- L (+ 2 M))))
(setq p28 (polar p16 B 1.5))
(setq p24 (polar p16 (- B (/ pi 2)) (/ D 2.0)))
(setq p25 (polar p16 (+ B (/ pi 2)) (/ D 2.0)))
(setq p27 (polar p24 (+ B 0.087266) (/ M (cos 0.087266))))
(setq p26 (polar p25 (- B 0.087266) (/ M (cos 0.087266))))
(if (>= (- L (+ 3 M)) D)
(progn
(setq N (/ (- L (+ 2 M)) D))
(setq X 1)
(Repeat N
(setq p17 (polar p28 (+ B pi) (* X D)))
(setq p18 (polar p17 (+ B (/ pi 2)) (/ D 2.0)))
(setq p19 (polar p17 (- B (/ pi 2)) (/ D 2.0)))
(setq p20 (polar p19 B 1.5))
(setq p21 (polar p18 B 1.5))
(setq p22 (polar p19 (+ B pi) 1.5))
(setq p23 (polar p18 (+ B pi) 1.5))
(command "line" (polar p21 B (- D 3.0)) p21 p20
(polar p20 B (- D 3.0)) "")
(command "arc" p20 "C" p19 p22)
(command "line" p22 p23 "")
(command "arc" p23 "C" p18 p21)
(setq X (+ 1 X)))
(command "line" p23 p7 "")
(command "line" p22 p8 ""))
(command "line" p7 p25 p24 p8 ""))
(command "pline" p24 "W" 0 0 p27 p26 p25 "")
(command "fillet" "R" 3.0 "fillet" "P" "L")
(command "line" p24 p25 "")
(setvar "blipmode" F))
